 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Processor
 *
 *  AUTHOR: Misagh Tavanpour
 *
 *  DATE: 10/12/2012
 *
 ***********************************************/

 #include "processor0.h"
 #include "message.h"       // InternalMessage ....
 #include <iostream>
 #include <fstream>
 ofstream UPI0 ("UE0PIn.txt");
 ofstream UPO0 ("UE0POut.txt");   //If this UE is a sender activate this line.
 ofstream UEM0 ("UE0PMode.txt");

 processor0::processor0( const std::string &name ) : Atomic( name )
 , In( addInputPort( "In" ) )
 , Req( addInputPort( "Req" ) )
 , Out( addInputPort( "Out" ) )
 , ProcessTime (00,00,00,02)
 , GenerateTime(00,00,00,20)
 {
 }

 Model &processor0::initFunction()
  {
    state = AskNewTask;	// waiting for new task
    Temp = 1;  //for the first time to ask new task from queue
    Mode = 0;
    RandCounter = 0;
    ServingBS = 0;
    SentPacketNum = 1;
    PreValue = 0;
    holdIn(Atomic::active, 0);  //Programmed to have an instantaneous internal transition.
	return *this ;
  }

 Model &processor0::externalFunction( const ExternalMessage &msg )
 { UPI0 << msg.time()<<" "<<msg.value()<<"\n";
   Temp = msg.value();    //Depart input message for future use.
   for (i=0;i<6;i++)
   {
	 Digit [i] = Temp % 10;
 	 Temp = Temp / 10;
   }

   if (Digit [3] == 0) //It is a Data packet. Send ACK for this packet to Source UE.
   {
 	 if (PreValue == msg.value()) //This is repeated pack (maybe because of JP transmission) ... so ask for new input from Queue
 	 {
 	   	state = AskNewTask;
 	   	Temp = 1;
 	 }
 	 else
 	 {
 	   PreValue = msg.value();
 	   state = RecPack;
 	   Temp = Digit [4] * 10;     //Receiver in ACK pack will be sender and vice versa.
 	   Temp = Temp + Digit [5];
 	   Temp = Temp * 10 + 1;      //Make it ACK pack.
 	   for (i=2;i>=0;i--) Temp = Temp * 10 + Digit [i];  //Add Packet Number to ACK message.
 	   OutPort = ServingBS;
 	 }
   }

   if (Digit [3] == 1 ) //It is a ACK packet.
   {
	 state = RecACK;
	 //Do nothing for time being.
   }

   if (Digit [3] == 2 ) //It is a BS to UE message. //Do nothing for time being.
   {
	 state = AskNewTask;
	 Temp = 1;
   }
   if (PreValue == msg.value()) holdIn(Atomic::active, 0);
      else holdIn(Atomic::active, ProcessTime);
   return *this;
 }

 Model &processor0::outputFunction( const InternalMessage &msg )
 {
   if ((state == RecPack) || (state == SendPack) || (state == UEMode))
   {
	 sendOutput( msg.time(), Out, Temp) ;
	 if (state == SendPack) UPO0 << msg.time()<<" "<<OutPort<<" "<<Temp<<"\n";
	 if (state == UEMode)   UEM0 << msg.time()<<" "<<OutPort<<" "<<Temp<<"\n";
   }

   if (state == AskNewTask) sendOutput( msg.time(),Req, Temp) ;
   return *this ;
 }

 Model &processor0::internalFunction( const InternalMessage & )
 {
   switch (state){
	   		       case Idle:
						      //Following lines should be active if this UE wants to send Data for other UEs.(Default is for UE2)
						      //Because this is UE0 so src should be 0 which means that 02abcd --> 2abcd
						      Temp = 20000 + SentPacketNum;  // Src = 0 , Des = 2 --> 020000 --> 20000
						      state = SendPack;
						      OutPort = ServingBS;
						      holdIn( Atomic::active, GenerateTime);
					          //passivate();
					    	  break;

			       case RecPack:
					    	     ReceivedPacketNum ++;
					    	     RandCounter ++;
					    	     if (RandCounter == 2) //The current receiving Mode will be save for next 100 packets.
					    	     {
					    	       state = UEMode;
					    	       Mode = rand() % 2;
					    	       RandCounter = 0;
					    	       OutPort = ServingBS;
					    	       if (Mode == 1) Temp = 113160;  //UEnumber + 1 --> for mentioning specific UE.
					    	          else Temp = 103160;
					    	     }
					    	       else
					    	    	   {
					    	    	     state = AskNewTask;
					    	    	     Temp = 1;
					    	    	   }
						         break;

				   case RecACK:
					            state = AskNewTask;
					            Temp = 1;
						        break;

				   case SendPack:
				    		      SentPacketNum ++;
				    		      state = Idle;
						          break;

				   case AskNewTask:
					                state = Idle;
					                break;

				   case UEMode:
					            state = AskNewTask;
					            break;
	        		  }
    return *this;
 }

 processor0::~processor0()
{
}
